

import { RenewalTypes, getSalesSettings } from './../RentalConstants.js';


export class ContractRentalLineForm {
	
	tpl = `
		<div class="contract-rental-line-form">
		
			<div class="article-name">{{line.lineDescription}}</div>	
			
			<div ez-if="line.rentalType == 'day'">
				<ez-date label="Start"
							name="startTime"
							[value]="line.startTime"></ez-date>
				<ez-date label="End"
							name="endTime"
							[value]="line.endTime"></ez-date>
			</div>
			<div ez-if="line.rentalType == 'hour'">
				<ez-datetime label="Start"
							name="startTime"
							[value]="line.startTime"></ez-datetime>
				<ez-datetime label="End"
							name="endTime"
							[value]="line.endTime"></ez-datetime>
			</div>
			
			
			<div class="renewal-period" ez-if="line.renewalType == 'week' || line.renewalType == 'month'">
				<label>{{_('Renewal period')}}</label>
				<ez-number label="Period"
							name="renewalPeriod" 
							min="0"
							[value]="line.renewalPeriod"></ez-number>
				
				<ez-select label="Renewal type"
							name="renewalType" 
							[options]="RenewalTypes" 
							[value]="line.renewalType"></ez-select>
			</div>
						
			<ez-price label="Price {{priceVat}}"
						name="price"
						[value]="price"></ez-price>
			
			
			<div style="margin-top: 25px;">
				<button [onclick]="widget.cancel">{{_('Cancel')}}</button>
				<button [onclick]="widget.save">{{_('Save')}}</button>
			</div
		</div>
	`;
	
	
	
	
	container = null;
	line = null;
	
	salesSettings = null;
	
	callbackCancel = null;
	callbackSave = null;
	
	
	constructor( container, line ) {
		this.container = container;
		this.line = line;
		
//		console.log('line', line);
	}
	
	
	
	save() {
		this.line.startTime     = $(this.container).find('input[name=startTime]').val();
		this.line.endTime       = $(this.container).find('input[name=endTime]').val();
		this.line.renewalPeriod = $(this.container).find('input[name=renewalPeriod]').val();
		this.line.renewalType   = $(this.container).find('select[name=renewalType]').val();
		
		let p = strtodouble( $(this.container).find('input[name=price]').val() );
		console.log('thep', p);
		if (this.salesSettings.inputPrice == 'excl_vat') {
			this.line.priceExclVat = p;
		}
		if (this.salesSettings.inputPrice == 'incl_vat') {
			this.line.priceInclVat = p;
		}
		
		if (this.callbackSave) {
			this.callbackSave( this.line );
		}
		else {
			console.error('RentalContractForm, callbackSave not set');
		}
		
		
		$(this.container).empty();
	}
	
	cancel() {
		if (this.callbackCancel) {
			this.callbackCancel();
		}
		
		$(this.container).empty();
	}
	
	
	setCancelCallback( callback ) {
		this.callbackCancel = callback;
	}
		
	
	setSaveCallback( callback ) {
		this.callbackSave = callback;
	}
	
	async render() {
		this.salesSettings = await getSalesSettings();
		
		let ezTpl = new EzTemplate( this.container );
		ezTpl.loadHtml( this.tpl );
		
		ezTpl.setObject('widget', this);
		ezTpl.setVar('line', this.line);
		ezTpl.setVar('RenewalTypes', RenewalTypes);
		ezTpl.setVar('salesSettings', this.salesSettings);
		
		if (this.salesSettings.inputPrice == 'excl_vat') {
			ezTpl.setVar('price', this.line.priceExclVat);
			ezTpl.setVar('priceVat', 'excl.');
		}
		if (this.salesSettings.inputPrice == 'incl_vat') {
			ezTpl.setVar('price', this.line.priceInclVat);
			ezTpl.setVar('priceVat', 'incl.');
		}
		
		
		ezTpl.render();
	}
	
	
}
